using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using CarLib;
using Microsoft.VisualStudio.DebuggerVisualizers;

[assembly:DebuggerVisualizer(
    typeof(CarVisualizer.DebuggerInterface),
    typeof(VisualizerObjectSource),
    Target = typeof(CarLib.Car),
    Description = "Wizualizator klasy Car")]
namespace CarVisualizer
{
    
    public class DebuggerInterface : DialogDebuggerVisualizer
    {
        public DebuggerInterface()
        {

        }

        #region IDebugVisualizer Members

		protected override void Show(IDialogVisualizerService windowService, IVisualizerObjectProvider objectProvider)
		{
			Car carClass = (Car)objectProvider.GetObject();

			new CarForm(carClass).ShowDialog();
		}    

		#endregion
}
}
